/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.ValueStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class VerifiedAccessInstanceCustomSubDomain
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, VerifiedAccessInstanceCustomSubDomain> {
    private static final SdkField<String> SUB_DOMAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubDomain").getter(VerifiedAccessInstanceCustomSubDomain.getter(VerifiedAccessInstanceCustomSubDomain::subDomain)).setter(VerifiedAccessInstanceCustomSubDomain.setter(Builder::subDomain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubDomain").unmarshallLocationName("subDomain").build()}).build();
    private static final SdkField<List<String>> NAMESERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Nameservers").getter(VerifiedAccessInstanceCustomSubDomain.getter(VerifiedAccessInstanceCustomSubDomain::nameservers)).setter(VerifiedAccessInstanceCustomSubDomain.setter(Builder::nameservers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NameserverSet").unmarshallLocationName("nameserverSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUB_DOMAIN_FIELD, NAMESERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = VerifiedAccessInstanceCustomSubDomain.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String subDomain;
    private final List<String> nameservers;

    private VerifiedAccessInstanceCustomSubDomain(BuilderImpl builder) {
        this.subDomain = builder.subDomain;
        this.nameservers = builder.nameservers;
    }

    public final String subDomain() {
        return this.subDomain;
    }

    public final boolean hasNameservers() {
        return this.nameservers != null && !(this.nameservers instanceof SdkAutoConstructList);
    }

    public final List<String> nameservers() {
        return this.nameservers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subDomain());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNameservers() ? this.nameservers() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VerifiedAccessInstanceCustomSubDomain)) {
            return false;
        }
        VerifiedAccessInstanceCustomSubDomain other = (VerifiedAccessInstanceCustomSubDomain)obj;
        return Objects.equals(this.subDomain(), other.subDomain()) && this.hasNameservers() == other.hasNameservers() && Objects.equals(this.nameservers(), other.nameservers());
    }

    public final String toString() {
        return ToString.builder((String)"VerifiedAccessInstanceCustomSubDomain").add("SubDomain", (Object)this.subDomain()).add("Nameservers", this.hasNameservers() ? this.nameservers() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SubDomain": {
                return Optional.ofNullable(clazz.cast(this.subDomain()));
            }
            case "Nameservers": {
                return Optional.ofNullable(clazz.cast(this.nameservers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SubDomain", SUB_DOMAIN_FIELD);
        map.put("NameserverSet", NAMESERVERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VerifiedAccessInstanceCustomSubDomain, T> g) {
        return obj -> g.apply((VerifiedAccessInstanceCustomSubDomain)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String subDomain;
        private List<String> nameservers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VerifiedAccessInstanceCustomSubDomain model) {
            this.subDomain(model.subDomain);
            this.nameservers(model.nameservers);
        }

        public final String getSubDomain() {
            return this.subDomain;
        }

        public final void setSubDomain(String subDomain) {
            this.subDomain = subDomain;
        }

        @Override
        public final Builder subDomain(String subDomain) {
            this.subDomain = subDomain;
            return this;
        }

        public final Collection<String> getNameservers() {
            if (this.nameservers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.nameservers;
        }

        public final void setNameservers(Collection<String> nameservers) {
            this.nameservers = ValueStringListCopier.copy(nameservers);
        }

        @Override
        public final Builder nameservers(Collection<String> nameservers) {
            this.nameservers = ValueStringListCopier.copy(nameservers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nameservers(String ... nameservers) {
            this.nameservers(Arrays.asList(nameservers));
            return this;
        }

        public VerifiedAccessInstanceCustomSubDomain build() {
            return new VerifiedAccessInstanceCustomSubDomain(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, VerifiedAccessInstanceCustomSubDomain> {
        public Builder subDomain(String var1);

        public Builder nameservers(Collection<String> var1);

        public Builder nameservers(String ... var1);
    }
}

