﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lightsail/Lightsail_EXPORTS.h>
#include <aws/lightsail/model/ContainerService.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lightsail {
namespace Model {
class CreateContainerServiceResult {
 public:
  AWS_LIGHTSAIL_API CreateContainerServiceResult() = default;
  AWS_LIGHTSAIL_API CreateContainerServiceResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LIGHTSAIL_API CreateContainerServiceResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>An object that describes a container service.</p>
   */
  inline const ContainerService& GetContainerService() const { return m_containerService; }
  template <typename ContainerServiceT = ContainerService>
  void SetContainerService(ContainerServiceT&& value) {
    m_containerServiceHasBeenSet = true;
    m_containerService = std::forward<ContainerServiceT>(value);
  }
  template <typename ContainerServiceT = ContainerService>
  CreateContainerServiceResult& WithContainerService(ContainerServiceT&& value) {
    SetContainerService(std::forward<ContainerServiceT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateContainerServiceResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  ContainerService m_containerService;

  Aws::String m_requestId;
  bool m_containerServiceHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lightsail
}  // namespace Aws
