﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift/RedshiftRequest.h>
#include <aws/redshift/Redshift_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Redshift {
namespace Model {

/**
 */
class DeleteSnapshotScheduleRequest : public RedshiftRequest {
 public:
  AWS_REDSHIFT_API DeleteSnapshotScheduleRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DeleteSnapshotSchedule"; }

  AWS_REDSHIFT_API Aws::String SerializePayload() const override;

 protected:
  AWS_REDSHIFT_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>A unique identifier of the snapshot schedule to delete.</p>
   */
  inline const Aws::String& GetScheduleIdentifier() const { return m_scheduleIdentifier; }
  inline bool ScheduleIdentifierHasBeenSet() const { return m_scheduleIdentifierHasBeenSet; }
  template <typename ScheduleIdentifierT = Aws::String>
  void SetScheduleIdentifier(ScheduleIdentifierT&& value) {
    m_scheduleIdentifierHasBeenSet = true;
    m_scheduleIdentifier = std::forward<ScheduleIdentifierT>(value);
  }
  template <typename ScheduleIdentifierT = Aws::String>
  DeleteSnapshotScheduleRequest& WithScheduleIdentifier(ScheduleIdentifierT&& value) {
    SetScheduleIdentifier(std::forward<ScheduleIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_scheduleIdentifier;
  bool m_scheduleIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
