/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.representations.idm.authorization;

import java.util.Map;
import java.util.Objects;
import org.keycloak.util.EnumWithStableIndex;

public enum DecisionStrategy implements EnumWithStableIndex
{
    AFFIRMATIVE(0),
    UNANIMOUS(1),
    CONSENSUS(2);

    private final int stableIndex;
    private static final Map<Integer, DecisionStrategy> BY_ID;

    private DecisionStrategy(int stableIndex) {
        Objects.requireNonNull(stableIndex);
        this.stableIndex = stableIndex;
    }

    @Override
    public int getStableIndex() {
        return this.stableIndex;
    }

    public static DecisionStrategy valueOfInteger(Integer id) {
        return id == null ? null : BY_ID.get(id);
    }

    static {
        BY_ID = EnumWithStableIndex.getReverseIndex((EnumWithStableIndex[])DecisionStrategy.values());
    }
}

