import { Bridge } from "matrix-appservice-bridge";
import { IrcRoom } from "../models/IrcRoom";
export interface RoomConfigConfig {
    enabled: boolean;
    lineLimitMax?: number;
    allowUnconnectedMatrixUsers?: boolean;
}
export declare class RoomConfig {
    private bridge;
    config?: RoomConfigConfig | undefined;
    static readonly STATE_EVENT_TYPE = "org.matrix.appservice-irc.config";
    private cache;
    constructor(bridge: Bridge, config?: RoomConfigConfig | undefined);
    /**
     * Fetch the state for the room, preferring a keyed state event over a global one.
     * This request will time out after `STATE_TIMEOUT_MS` if the state could not be fetched in time.
     * @param roomId The Matrix room ID
     * @param ircRoom The IRC room we want the configuration for.
     * @returns A content object containing the configuration, or null if the event was not found or the
     *          request timed out.
     */
    private getRoomState;
    /**
     * Invalidate the cache for a room.
     * @param roomId The Matrix roomId
     * @param stateKey The state event's key
     */
    invalidateConfig(roomId: string, stateKey?: string): void;
    /**
     * Get the per-room configuration for the paste bin limit for a room.
     * Only "channel" room types are supported. Non "channel" types will return null.
     * @param roomId The Matrix roomId
     * @param ircRoom The IRC roomId. Optional.
     * @returns The number of lines required for a pastebin. `null` means no limit set in the room.
     */
    getLineLimit(roomId: string, ircRoom?: IrcRoom): Promise<number | null>;
    /**
     * Check if the room allows or denys unconnected matrix users.
     * @param roomId The Matrix roomId
     * @param ircRoom The IRC roomId. Optional.
     * @returns Whether unconnected Matrix users are allowed in the room. Will return null if not set.
     */
    allowUnconnectedMatrixUsers(roomId: string, ircRoom?: IrcRoom): Promise<boolean | null>;
}
