/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.image.impl;

import com.sun.javafx.image.AlphaType;
import com.sun.javafx.image.IntPixelAccessor;
import com.sun.javafx.image.IntPixelGetter;
import com.sun.javafx.image.IntPixelSetter;
import com.sun.javafx.image.IntToIntPixelConverter;
import com.sun.javafx.image.PixelUtils;
import com.sun.javafx.image.impl.BaseIntToIntConverter;
import com.sun.javafx.image.impl.IntArgbPre;
import java.nio.IntBuffer;

public class IntRgb {
    public static final IntPixelGetter getter = Accessor.instance;
    public static final IntPixelSetter setter = Accessor.instance;
    public static final IntPixelAccessor accessor = Accessor.instance;

    private IntRgb() {
    }

    public static IntToIntPixelConverter ToIntArgbPreConverter() {
        return ToIntArgbPreConv.instance;
    }

    public static class ToIntArgbPreConv
    extends BaseIntToIntConverter {
        public static final IntToIntPixelConverter instance = new ToIntArgbPreConv();

        private ToIntArgbPreConv() {
            super(getter, IntArgbPre.setter);
        }

        @Override
        void doConvert(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int n5, int n6) {
            n2 -= n5;
            n4 -= n5;
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = nArray[n++];
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 & 0xFF;
                    nArray2[n3++] = 0xFF000000 | n8 << 16 | n9 << 8 | n10;
                }
                n += n2;
                n3 += n4;
            }
        }

        @Override
        void doConvert(IntBuffer intBuffer, int n, int n2, IntBuffer intBuffer2, int n3, int n4, int n5, int n6) {
            while (--n6 >= 0) {
                for (int i = 0; i < n5; ++i) {
                    int n7 = intBuffer.get(n + i);
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 & 0xFF;
                    intBuffer2.put(n3 + i, 0xFF000000 | n8 << 16 | n9 << 8 | n10);
                }
                n += n2;
                n3 += n4;
            }
        }
    }

    static class Accessor
    implements IntPixelAccessor {
        static final IntPixelAccessor instance = new Accessor();

        private Accessor() {
        }

        @Override
        public AlphaType getAlphaType() {
            return AlphaType.OPAQUE;
        }

        @Override
        public int getNumElements() {
            return 1;
        }

        @Override
        public int getArgb(int[] nArray, int n) {
            return nArray[n] | 0xFF000000;
        }

        @Override
        public int getArgbPre(int[] nArray, int n) {
            return PixelUtils.NonPretoPre(nArray[n] | 0xFF000000);
        }

        @Override
        public int getArgb(IntBuffer intBuffer, int n) {
            return intBuffer.get(n) | 0xFF000000;
        }

        @Override
        public int getArgbPre(IntBuffer intBuffer, int n) {
            return PixelUtils.NonPretoPre(intBuffer.get(n) | 0xFF000000);
        }

        @Override
        public void setArgb(int[] nArray, int n, int n2) {
            nArray[n] = n2 | 0xFF000000;
        }

        @Override
        public void setArgbPre(int[] nArray, int n, int n2) {
            nArray[n] = PixelUtils.PretoNonPre(n2) | 0xFF000000;
        }

        @Override
        public void setArgb(IntBuffer intBuffer, int n, int n2) {
            intBuffer.put(n, n2 | 0xFF000000);
        }

        @Override
        public void setArgbPre(IntBuffer intBuffer, int n, int n2) {
            intBuffer.put(n, PixelUtils.PretoNonPre(n2) | 0xFF000000);
        }
    }
}

