/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import reactor.core.CoreSubscriber;
import reactor.core.Scannable;
import reactor.core.publisher.FluxOnErrorReturn;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;

final class MonoOnErrorReturn<T>
extends InternalMonoOperator<T, T> {
    final @Nullable Predicate<? super Throwable> resumableErrorPredicate;
    final @Nullable T fallbackValue;

    MonoOnErrorReturn(Mono<? extends T> source, @Nullable Predicate<? super Throwable> predicate, @Nullable T value) {
        super(source);
        this.resumableErrorPredicate = predicate;
        this.fallbackValue = value;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return new FluxOnErrorReturn.ReturnSubscriber<T>(actual, (Predicate<Throwable>)this.resumableErrorPredicate, this.fallbackValue, false);
    }

    @Override
    public @Nullable Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

