/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.routing.allocation;

import java.util.function.Predicate;
import org.opensearch.cluster.routing.allocation.Constraint;

public class ConstraintTypes {
    public static final long CONSTRAINT_WEIGHT = 1000000L;
    public static final String INDEX_PRIMARY_SHARD_BALANCE_CONSTRAINT_ID = "index.primary.shard.balance.constraint";
    public static final String CLUSTER_PRIMARY_SHARD_BALANCE_CONSTRAINT_ID = "cluster.primary.shard.balance.constraint";
    public static final String CLUSTER_PRIMARY_SHARD_REBALANCE_CONSTRAINT_ID = "cluster.primary.shard.rebalance.constraint";
    public static final String INDEX_SHARD_PER_NODE_BREACH_CONSTRAINT_ID = "index.shard.count.constraint";

    public static Predicate<Constraint.ConstraintParams> isIndexShardsPerNodeBreached() {
        return params -> {
            int allowedIndexShardsPerNode;
            int currIndexShardsOnNode = params.getNode().numShards(params.getIndex());
            return currIndexShardsOnNode >= (allowedIndexShardsPerNode = (int)Math.ceil(params.getBalancer().avgShardsPerNode(params.getIndex())));
        };
    }

    public static Predicate<Constraint.ConstraintParams> isPerIndexPrimaryShardsPerNodeBreached() {
        return params -> {
            int perIndexAllowedPrimaryShardCount;
            int perIndexPrimaryShardCount = params.getNode().numPrimaryShards(params.getIndex());
            return perIndexPrimaryShardCount >= (perIndexAllowedPrimaryShardCount = (int)Math.ceil(params.getBalancer().avgPrimaryShardsPerNode(params.getIndex())));
        };
    }

    public static Predicate<Constraint.ConstraintParams> isPrimaryShardsPerNodeBreached(float buffer) {
        return params -> {
            int allowedPrimaryShardCount;
            int primaryShardCount = params.getNode().numPrimaryShards();
            return primaryShardCount >= (allowedPrimaryShardCount = (int)Math.ceil(params.getBalancer().avgPrimaryShardsPerNode() * (1.0f + buffer)));
        };
    }

    public static long predicateKeyToWeightMap(String key, long primaryConstraintWeight) {
        switch (key) {
            case "cluster.primary.shard.balance.constraint": 
            case "cluster.primary.shard.rebalance.constraint": {
                return primaryConstraintWeight;
            }
        }
        return 1000000L;
    }
}

