import ky from 'ky';
export class Gitlab {
    _protocol;
    _domain;
    _apiPrefix;
    _token;
    constructor(options = {}) {
        this._protocol = options.protocol || 'https';
        this._domain = options.domain || 'gitlab.archlinux.org';
        this._apiPrefix = options.apiPrefix || '/api/v4';
        this._token = options.token || '';
    }
    setToken(token) {
        if (token) {
            this._token = token;
        }
    }
    getHomepage() {
        return `${this._protocol}://${this._domain}/`;
    }
    getUrlPrefix() {
        return `${this._protocol}://${this._domain}${this._apiPrefix}`;
    }
    async getTags(repoPath) {
        try {
            const headers = {};
            if (this._token) {
                headers['Authorization'] = `token ${this._token}`;
            }
            const resp = await ky.get(`${this.getUrlPrefix()}/projects/${encodeURIComponent(repoPath)}/repository/tags`, {
                headers
            });
            return await resp.json();
        }
        catch (err) {
            throw err;
        }
    }
    getPackageTags(pkgBase) {
        return this.getTags(`archlinux/packaging/packages/${pkgBase}`);
    }
}
export default Gitlab;
