/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.DBPDataSourcePermission;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.utils.CommonUtils;

public class EditConnectionPermissionsDialog
extends BaseDialog {
    private List<DBPDataSourcePermission> accessRestrictions;
    private List<Button> restrictedPermissionButtons = new ArrayList<Button>();

    public EditConnectionPermissionsDialog(Shell shell, List<DBPDataSourcePermission> accessRestrictions) {
        super(shell, CoreMessages.dialog_connection_wizard_final_group_security, null);
        this.accessRestrictions = CommonUtils.safeList(accessRestrictions);
    }

    protected Composite createDialogArea(Composite parent) {
        Composite composite = super.createDialogArea(parent);
        DBPDataSourcePermission[] dBPDataSourcePermissionArray = DBPDataSourcePermission.values();
        int n = dBPDataSourcePermissionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPDataSourcePermission permission = dBPDataSourcePermissionArray[n2];
            Button permButton = UIUtils.createCheckbox((Composite)composite, (String)permission.getLabel(), (String)permission.getDescription(), (boolean)this.accessRestrictions.contains(permission), (int)1);
            permButton.setData((Object)permission);
            permButton.setLayoutData((Object)new GridData(32));
            this.restrictedPermissionButtons.add(permButton);
            ++n2;
        }
        return composite;
    }

    protected void okPressed() {
        ArrayList<DBPDataSourcePermission> restrictions = new ArrayList<DBPDataSourcePermission>();
        for (Button permButton : this.restrictedPermissionButtons) {
            if (!permButton.getSelection()) continue;
            restrictions.add((DBPDataSourcePermission)permButton.getData());
        }
        this.accessRestrictions = restrictions;
        super.okPressed();
    }

    public List<DBPDataSourcePermission> getAccessRestrictions() {
        return this.accessRestrictions;
    }
}

