/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.geom.Dimension2D;
import java.awt.image.ImageObserver;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import sun.awt.image.AbstractMultiResolutionImage;
import sun.awt.image.ImageCache;
import sun.awt.image.ToolkitImage;

public class MultiResolutionCachedImage
extends AbstractMultiResolutionImage {
    private final int baseImageWidth;
    private final int baseImageHeight;
    private final Dimension2D[] sizes;
    private final BiFunction<Integer, Integer, Image> mapper;
    private int availableInfo;

    public MultiResolutionCachedImage(int n, int n2, BiFunction<Integer, Integer, Image> biFunction) {
        this(n, n2, new Dimension[]{new Dimension(n, n2)}, biFunction);
    }

    public MultiResolutionCachedImage(int n, int n2, Dimension2D[] dimension2DArray, BiFunction<Integer, Integer, Image> biFunction) {
        this.baseImageWidth = n;
        this.baseImageHeight = n2;
        this.sizes = dimension2DArray == null ? null : Arrays.copyOf(dimension2DArray, dimension2DArray.length);
        this.mapper = biFunction;
    }

    @Override
    public Image getResolutionVariant(int n, int n2) {
        ImageCacheKey imageCacheKey;
        ImageCache imageCache = ImageCache.getInstance();
        Image image = imageCache.getImage(imageCacheKey = new ImageCacheKey(this, n, n2));
        if (image == null) {
            image = this.mapper.apply(n, n2);
            imageCache.setImage(imageCacheKey, image);
        }
        MultiResolutionCachedImage.preload(image, this.availableInfo);
        return image;
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Arrays.stream(this.sizes).map((? super T dimension2D) -> this.getResolutionVariant((int)dimension2D.getWidth(), (int)dimension2D.getHeight())).collect(Collectors.toList());
    }

    public MultiResolutionCachedImage map(Function<Image, Image> function) {
        return new MultiResolutionCachedImage(this.baseImageWidth, this.baseImageHeight, this.sizes, (n, n2) -> (Image)function.apply(this.getResolutionVariant((int)n, (int)n2)));
    }

    @Override
    public int getWidth(ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 1);
        return super.getWidth(imageObserver);
    }

    @Override
    public int getHeight(ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 2);
        return super.getHeight(imageObserver);
    }

    @Override
    public Object getProperty(String string, ImageObserver imageObserver) {
        this.updateInfo(imageObserver, 4);
        return super.getProperty(string, imageObserver);
    }

    @Override
    protected Image getBaseImage() {
        return this.getResolutionVariant(this.baseImageWidth, this.baseImageHeight);
    }

    private void updateInfo(ImageObserver imageObserver, int n) {
        this.availableInfo |= imageObserver == null ? 32 : n;
    }

    private static int getInfo(Image image2) {
        if (image2 instanceof ToolkitImage) {
            return ((ToolkitImage)image2).getImageRep().check((image, n, n2, n3, n4, n5) -> false);
        }
        return 0;
    }

    private static void preload(Image image, final int n) {
        if (n != 0 && image instanceof ToolkitImage) {
            ((ToolkitImage)image).preload(new ImageObserver(){
                int flags;
                {
                    this.flags = n;
                }

                @Override
                public boolean imageUpdate(Image image, int n6, int n2, int n3, int n4, int n5) {
                    this.flags &= ~n6;
                    return this.flags != 0 && (n6 & 0xC0) == 0;
                }
            });
        }
    }

    private static class ImageCacheKey
    implements ImageCache.PixelsKey {
        private final int pixelCount;
        private final int hash;
        private final int w;
        private final int h;
        private final Image baseImage;

        ImageCacheKey(Image image, int n, int n2) {
            this.baseImage = image;
            this.w = n;
            this.h = n2;
            this.pixelCount = n * n2;
            this.hash = this.hash();
        }

        @Override
        public int getPixelCount() {
            return this.pixelCount;
        }

        private int hash() {
            int n = this.baseImage.hashCode();
            n = 31 * n + this.w;
            n = 31 * n + this.h;
            return n;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ImageCacheKey) {
                ImageCacheKey imageCacheKey = (ImageCacheKey)object;
                return this.baseImage == imageCacheKey.baseImage && this.w == imageCacheKey.w && this.h == imageCacheKey.h;
            }
            return false;
        }
    }
}

